-- // ============================================================
-- // == INTERNATIONAL GAMING CENTER NETWORK
-- // == www.igcn.mu
-- // == (C) 2010-2025 IGC-Network (R)
-- // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
-- // == File is a part of IGCN Group MuOnline Server files.
-- // ============================================================

-- Note: FORMULA BLOCK should match FORMULA BLOCK configured on server side in \Data\Scripts\Misc\ExpCalc.lua, ExpSystemCalc function

function ExpSystemCalc(FormulaID, PlayerVipType, StaticExp, DynamicExp, EventExp, VipExp, BonusEvent, MapBonusExp, MiscExp)
	local Exp = 0
	
-- ### FORMULA BLOCK START ###
	if (FormulaID == 0) then
		Exp = StaticExp+(EventExp+VipExp+BonusEvent+MapBonusExp);
		DynamicExp = 0; -- not used in the formula, set to 0 to avoid display
	elseif (FormulaID == 1) then
		Exp = StaticExp+DynamicExp+(EventExp+VipExp+BonusEvent+MapBonusExp);
	elseif (FormulaID == 2) then
		Exp = StaticExp*DynamicExp+(EventExp+VipExp+BonusEvent+MapBonusExp);
	elseif (FormulaID == 3) then
		Exp = DynamicExp+(EventExp+VipExp+BonusEvent+MapBonusExp);
		StaticExp = 0; -- not used in the formula, set to 0 to avoid display
	elseif (FormulaID == 4) then
		Exp = (StaticExp+EventExp+VipExp+BonusEvent+MapBonusExp)*DynamicExp;
	elseif (FormulaID == 5) then
		if (VipExp <= 0) then -- default is 0, set to 1 (no change) as it is used as multiplier
			VipExp = 1.0;
		end
		
		Exp = (StaticExp+DynamicExp+EventExp+BonusEvent+MapBonusExp)*VipExp;
	end

	if (MiscExp > 0) then
		Exp = Exp + (Exp * MiscExp / 100)
	end
-- ### FORMULA BLOCK END ###
	
	return StaticExp, DynamicExp, EventExp, VipExp, BonusEvent, MapBonusExp, MiscExp, Exp;
end